<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminUserController;
use App\Http\Controllers\Admin\AdminSliderController;
use App\Http\Controllers\Admin\AdminAboutController;
use App\Http\Controllers\Admin\AdminAcademicsController;
use App\Http\Controllers\Admin\AdminCourseController;
use App\Http\Controllers\Admin\AdminCoursePageController;
use App\Http\Controllers\Admin\AdminCoursePartController;
use App\Http\Controllers\Admin\AdminCourseSubjectController;
use App\Http\Controllers\Admin\AdminDepartmentMessageController;
use App\Http\Controllers\Admin\AdminDownloadController;
use App\Http\Controllers\User\UserAboutController;
use App\Http\Controllers\User\UserCourseController;
use App\Http\Controllers\Admin\AdminDPTMessage;
use App\Http\Controllers\Admin\AdminThemeController;
use App\Http\Controllers\Admin\AdminInformationController;
use App\Http\Controllers\Admin\AdminDepartmentDownloadController;
use App\Http\Controllers\Admin\AdminTestimonailController;
use App\Http\Controllers\Admin\AdminReasonController;
use App\Http\Controllers\Admin\AdminMessageController;
use App\Http\Controllers\Admin\AdminNewsNoticeController;
use App\Http\Controllers\Admin\AdminEventsController;
use App\Http\Controllers\User\UserResultController;
use App\Http\Controllers\User\UserLanguageController;
use App\Http\Controllers\Admin\AdminGalleryController;
use App\Http\Controllers\Admin\AdminVideoController;
use App\Http\Controllers\User\UserDepartmentsController;
use App\Http\Controllers\User\UserDownloadController;
use App\Http\Controllers\User\UserFacilitatesController;
use App\Http\Controllers\User\UserContactController;
use App\Http\Controllers\User\UserGalleryController;
use App\Http\Controllers\User\UserNewsNoticeController;
use App\Http\Controllers\Admin\AdminAdmissionController;
use App\Http\Controllers\Admin\AdminEntranceController;
use App\Http\Controllers\Admin\AdminEntrancepdfController;
use App\Http\Controllers\Admin\AdminFacultiesStaffController;
use App\Http\Controllers\Admin\AdminFooterController;
use App\Http\Controllers\Admin\AdminResourcesController;
use App\Http\Controllers\Admin\AdminStaticVideoController;
use App\Http\Controllers\User\UserAdmissionController;
use App\Http\Controllers\User\UserEventController;
use App\Http\Controllers\User\UserApplicationController;
use App\Http\Controllers\Admin\AdminEntranceProcessController;
use App\Http\Controllers\Admin\AdminPremissionController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('user.index');
});
Route::get('about', [UserAboutController::class, 'UserAbout'])->name('user.about');
Route::get('faculties-and-staff', [UserAboutController::class, 'UserUserStaff'])->name('user.staff');
Route::get('academics', [UserAboutController::class, 'UserAcademics'])->name('user.academics');
Route::get('message-view/{id}/{slug}', [UserAboutController::class, 'UserUserMessage'])->name('user.message');
Route::get('course-details-view/{id}/{slug}', [UserCourseController::class, 'UserCourseView'])->name('user.course_details');
Route::get('course', [UserCourseController::class, 'UserCourse'])->name('user.course');
Route::get('result/{id}/{slug}',[UserResultController::class, 'UserResultView'])->name('user.results');
Route::get('result-download/{id}',[UserResultController::class, 'UserResultsDownload'])->name('user.result_download');
Route::get('result-view/{id}',[UserResultController::class, 'UserResultsView'])->name('user.result_view');
Route::get('result-download-view/{id}',[UserResultController::class, 'UserResultsDownloadView'])->name('user.result_download_view');
Route::get('department/{id}/{slug}',[UserDepartmentsController::class, 'UserDepartmentsView'])->name('user.departments');
Route::get('admission-details/{id}/{slug}', [UserAdmissionController::class, 'UserAdmissionView'])->name('user.admissions');
Route::post('/email', [UserContactController::class, 'sendEmail'])->name('send.email');
Route::get('/notice', [UserNewsNoticeController::class, 'UserNoticeListView'])->name('user.notice');
Route::get('/news-notice-details/{id}/{slug}', [UserNewsNoticeController::class, 'UserNewsNoticeDetails'])->name('user.news_notice_details');
//User Gallery 

Route::get('/entrance-application', [UserApplicationController::class, 'UserApplicationForm'])->name('user.application');
Route::get('/entrance-application-pdf/{id}', [UserApplicationController::class, 'UserEntrancePDFView'])->name('user.application_pdf');
Route::get('/events', [UserEventController::class, 'EventManageView'])->name('user.user_event');
Route::get('/events-details/{id}/{slug}', [UserEventController::class, 'EventManageDetailsView'])->name('user.user_event_details');

Route::get('/gallery', [UserGalleryController::class, 'UserGalleryView'])->name('user.gallery');
Route::get('gallery-details/{id}/{slug}', [UserGalleryController::class, 'UserGalleryDetailsView'])->name('user.gallery_details');
Route::get('/videos', [UserGalleryController::class, 'UserVideosView'])->name('user.videos');
//Download Routes
Route::get('download', [UserDownloadController::class, 'UserDownloadView'])->name('user.download');


Route::get('download-pdf-read/{id}', [UserDownloadController::class, 'UserDownloadFilePDFView'])->name('user.download_view');
Route::get('download-file-view/{id}',[UserDownloadController::class, 'UserDownloadFileView'])->name('user.download_file_view');
Route::get('download-details/{id}/{slug}',[UserDownloadController::class, 'UserDownloadFileDetailsView'])->name('user.download_details');

Route::get('facilitates', [UserFacilitatesController::class, 'UserFacilitatesView'])->name('user.facilitates');
Route::get('facilitates-details/{id}/{slug}', [UserFacilitatesController::class, 'UserFacilitatesDetailsView'])->name('user.facilitates_details');

Route::get('/language/hindi', [UserLanguageController::class, 'NepaliLanguage'])->name('nepali.language');
Route::get('/language/english', [UserLanguageController::class, 'EnglishLanguage'])->name('english.language');

Route::get('contact',[UserContactController::class, 'ContactView'])->name('user.contact');
Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified'
])->group(function () {
    Route::get('/dashboard', function () {
        return view('admin.index');
    })->name('dashboard');
});

Route::get('/comming-soon', function () {
    return view('user.comming');
})->name('comming_soon');
//Admin Profile Routes
Route::get('/admin/profile', [AdminUserController::class, 'AdminUserProfile'])->name('admin.profile');
Route::post('/admin/profile-image', [AdminUserController::class, 'AdminProfileImage'])->name('admin.profile_image');
Route::post('/admin/profile-info-store', [AdminUserController::class, 'AdminProfileInfoStore'])->name('admin.profile_info_store');


//Admin Password Changes
Route::get('/admin/password', [AdminUserController::class, 'AdminUserPasswordview'])->name('admin.passwordview');
Route::post('/admin/check-password', [AdminUserController::class, 'checkUserPassword'])->name('admin.change.password');
Route::post('/admin/update-password', [AdminUserController::class, 'ChangePasswordUpdate'])->name('admin.update_password');


//Admin Profile logout
Route::get('/admin/logout', [AdminUserController::class, 'AdminLogout'])->name('admin.logout');

//Admin Slider Routes
Route::get('/admin/slider-add', [AdminSliderController::class, 'SliderAdd'])->name('admin.slider_add');
Route::get('/admin/slider-view', [AdminSliderController::class, 'SliderView'])->name('admin.slider_view');
Route::post('/admin/slider-store', [AdminSliderController::class, 'SliderStore'])->name('admin.slider_store');
Route::get('/admin/slider-edit/{id}', [AdminSliderController::class, 'SliderEdit'])->name('admin.slider_edit');
Route::post('/admin/slider-update/{id}', [AdminSliderController::class, 'SliderUpdate'])->name('admin.slider_update');
Route::get('/admin/slider-delete/{id}', [AdminSliderController::class, 'SliderDelete'])->name('admin.slider_delete');
Route::get('/admin/slider-active/{id}', [AdminSliderController::class, 'SliderActive'])->name('admin.slider_view.active');
Route::get('/admin/slider-inactive/{id}', [AdminSliderController::class, 'SliderInactive'])->name('admin.slider_view.inactive');
Route::post('/admin/slider-delete/{id}', [AdminSliderController::class, 'SliderDelete'])->name('admin.slider_view.delete');



//About Update
Route::get('/admin/about', [AdminAboutController::class, 'AdminAboutUpdate'])->name('admin.about_update');
Route::post('/admin/about-store', [AdminAboutController::class, 'AdminAboutUpdateStore'])->name('admin.about_update_store');


//Course
Route::get('/admin/course', [AdminCourseController::class, 'AdminCourseView'])->name('admin.course_view');
Route::post('/admin/course-store', [AdminCourseController::class, 'AdminCourseStore'])->name('admin.course_store');
Route::post('/admin/course-update/{id}', [AdminCourseController::class, 'AdminCourseUpdate'])->name('admin.course_update');
Route::get('/admin/course-delete/{id}', [AdminCourseController::class, 'AdminCourseDelete'])->name('admin.course_delete');


//Course Part 
Route::get('/admin/course-part', [AdminCoursePartController::class, 'AdminCoursePartView'])->name('admin.course_part_view');
Route::post('/admin/course-part-store', [AdminCoursePartController::class, 'AdminCoursePartStore'])->name('admin.course_part_store');
Route::get('/admin/course-edit/{id}', [AdminCoursePartController::class, 'AdminCoursePartEdit'])->name('admin.course_part_edit');
Route::post('/admin/course-part-update/{id}', [AdminCoursePartController::class, 'AdminCoursePartUpdate'])->name('admin.course_part_update');
Route::get('/admin/course-part-delete/{id}', [AdminCoursePartController::class, 'AdminCoursePartDelete'])->name('admin.course_part_delete');



//Course Part 
Route::get('/admin/course-subject/{id}', [AdminCourseSubjectController::class, 'AdminCoursePartSubject'])->name('admin.course_part_subject');
Route::get('/admin/course-subject-ajax', [AdminCourseSubjectController::class, 'AdminCoursePartSubjectAJAX'])->name('admin.course_part_subject_ajax');
Route::post('/admin/course-part-store-subject', [AdminCourseSubjectController::class, 'AdminCoursePartStoreSubject'])->name('admin.course_part_store_subject');
Route::post('/admin/course-part-update-subject/{id}', [AdminCourseSubjectController::class, 'AdminCoursePartUpdateSubject'])->name('admin.course_part_update_subject');
Route::get('/admin/course-part-subject-delete/{id}', [AdminCourseSubjectController::class, 'AdminCoursePartSubjectDelete'])->name('admin.course_part_subject_delete');


//Course Page Manage
Route::get('/admin/course-page', [AdminCoursePageController::class, 'AdminCoursePageView'])->name('admin.course_page_view');
Route::get('/admin/course-page-add', [AdminCoursePageController::class, 'AdminCoursePageAdd'])->name('admin.course_page_add');
Route::post('/admin/course-page-store', [AdminCoursePageController::class, 'AdminCoursePageStore'])->name('admin.course_page_store');
Route::post('/admin/course-page-update/{id}', [AdminCoursePageController::class, 'AdminCoursePageUpdate'])->name('admin.course_page_update');
Route::get('/admin/course-page-edit/{id}', [AdminCoursePageController::class, 'AdminCoursePageEdit'])->name('admin.course_page_edit');
Route::get('/admin/course-page-delete/{id}', [AdminCoursePageController::class, 'AdminCoursePageDelete'])->name('admin.course_page_delete');

//Department Message Routes




//User Route
Route::get('/admin/user-add', [AdminUserController::class, 'AdminUserAddView'])->name('admin.user_add_view');
Route::post('/admin/user-store', [AdminUserController::class, 'AdminUserAddInfoStore'])->name('admin.user_add_info_store');
Route::get('/admin/user-all-view', [AdminUserController::class, 'AdminUserAllView'])->name('admin.user_all_view');
Route::get('/admin/user-all-edit/{id}', [AdminUserController::class, 'AdminUserAllEdit'])->name('admin.user_all_edit');
Route::post('/admin/user-update/{id}', [AdminUserController::class, 'AdminUserAddInfoUpdate'])->name('admin.user_add_info_update');
Route::get('/admin/user-all-delete/{id}', [AdminUserController::class, 'AdminUserAllDelete'])->name('admin.user_all_delete');


//Departments Message
Route::get('/admin/department-message-add', [AdminDepartmentMessageController::class, 'AdminDepartmentMessageAddView'])->name('admin.user__department_add_view');
Route::post('/admin/department-message-store', [AdminDepartmentMessageController::class, 'AdminDepartmentMessageStore'])->name('admin.user__department_add_store');
Route::get('/admin/department-message-all-view', [AdminDepartmentMessageController::class, 'AdminDepartmentMessageView'])->name('admin.user__department_view');
Route::get('/admin/department-message-all-edit/{id}', [AdminDepartmentMessageController::class, 'AdminDepartmentMessageEdit'])->name('admin.user__department_add_edit');
Route::post('/admin/department-message-update/{id}', [AdminDepartmentMessageController::class, 'AdminDepartmentMessageUpdate'])->name('admin.user__department_add_update');
Route::get('/admin/department-message-delete/{id}', [AdminDepartmentMessageController::class, 'AdminDepartmentMessageDelete'])->name('admin.user__department_add_delete');



Route::get('/admin/download-all-view',[AdminDownloadController::class, 'AdminDownloadAllView'])->name('admin.download_all_view');
Route::get('/admin/download-all-add',[AdminDownloadController::class, 'AdminDownloadAllAdd'])->name('admin.download_all_add');
Route::post('/admin/download-all-store',[AdminDownloadController::class, 'AdminDownloadAllStore'])->name('admin.download_all_store');
Route::get('/admin/download-all-edit/{id}', [AdminDownloadController::class, 'AdminDownloadAllEdit'])->name('admin.download_all_edit');
Route::post('/admin/download-all-update/{id}', [AdminDownloadController::class, 'AdminDownloadAllUpdate'])->name('admin.download_all_update');
Route::get('/admin/download-all-delete/{id}', [AdminDownloadController::class, 'AdminDownloadAllDelete'])->name('admin.download_all_delete');
Route::get('/admin/download-all-active/{id}', [AdminDownloadController::class, 'AdminDownloadAllActive'])->name('admin.download_all_active');
Route::get('/admin/download-all-inactive/{id}', [AdminDownloadController::class, 'AdminDownloadAllInactive'])->name('admin.download_all_inactive');



//Admin Theme Update
Route::get('/admin/theme-all-update',[AdminThemeController::class, 'AdminThemeUpdateView'])->name('admin.theme_update_view');
Route::post('/admin/theme-all-update-store',[AdminThemeController::class, 'AdminThemeUpdateStore'])->name('admin.theme_update_store');

//Admin INformation Routes
Route::get('/admin/information-all-update',[AdminInformationController::class, 'AdminInformationUpdateView'])->name('admin.information_update_view');
Route::post('/admin/information-all-store/{id}',[AdminInformationController::class, 'AdminInformationUpdateStore'])->name('admin.information_update_store');




//Department Wise Notice
Route::get('/admin/department-download-all-view',[AdminDepartmentDownloadController::class, 'AdminDepartmentDownloadAllView'])->name('admin.department_download_all_view');
Route::get('/admin/department-download-all-add',[AdminDepartmentDownloadController::class, 'AdminDepartmentDownloadAllAdd'])->name('admin.department_download_all_add');
Route::post('/admin/department-download-all-store',[AdminDepartmentDownloadController::class, 'AdminDepartmentDownloadAllStore'])->name('admin.department_download_all_store');
Route::get('/admin/department-download-all-edit/{id}', [AdminDepartmentDownloadController::class, 'AdminDepartmentDownloadAllEdit'])->name('admin.department_download_all_edit');
Route::post('/admin/department-download-all-update/{id}', [AdminDepartmentDownloadController::class, 'AdminDepartmentDownloadAllUpdate'])->name('admin.department_download_all_update');
Route::get('/admin/department-download-all-delete/{id}', [AdminDepartmentDownloadController::class, 'AdminDepartmentDownloadAllDelete'])->name('admin.department_download_all_delete');
Route::get('/admin/department-download-all-active/{id}', [AdminDepartmentDownloadController::class, 'AdminDepartmentDownloadAllActive'])->name('admin.department_download_all_active');
Route::get('/admin/department-download-all-inactive/{id}', [AdminDepartmentDownloadController::class, 'AdminDepartmentDownloadAllInactive'])->name('admin.department_download_all_inactive');

//Testimonials Routes
Route::get('/admin/testimonail-view', [AdminTestimonailController::class, 'AdminTestimonailView'])->name('admin.testimonail_view');
Route::post('/admin/testimonail-store', [AdminTestimonailController::class, 'AdminTestimonailStore'])->name('admin.testimonail_store');
Route::get('/admin/testimonail-edit/{id}', [AdminTestimonailController::class, 'AdminTestimonailEdit'])->name('admin.testimonail_edit');
Route::post('/admin/testimonail-update/{id}', [AdminTestimonailController::class, 'AdminTestimonailUpdate'])->name('admin.testimonail_update');
Route::get('/admin/testimonail-delete/{id}', [AdminTestimonailController::class, 'AdminTestimonailDelete'])->name('admin.testimonail_delete');


//Department Wise Notice
Route::get('/admin/reason-all-view',[AdminReasonController::class, 'AdminReasonAllView'])->name('admin.reason_all_view');
Route::get('/admin/reason-all-add',[AdminReasonController::class, 'AdminReasonAllAdd'])->name('admin.reason_all_add');
Route::post('/admin/reason-all-store',[AdminReasonController::class, 'AdminReasonAllStore'])->name('admin.reason_all_store');
Route::get('/admin/reason-all-edit/{id}', [AdminReasonController::class, 'AdminReasonAllEdit'])->name('admin.reason_all_edit');
Route::post('/admin/reason-all-update/{id}', [AdminReasonController::class, 'AdminReasonAllUpdate'])->name('admin.reason_all_update');
Route::get('/admin/reason-all-delete/{id}', [AdminReasonController::class, 'AdminReasonAllDelete'])->name('admin.reason_all_delete');
Route::get('/admin/reason-all-active/{id}', [AdminReasonController::class, 'AdminReasonAllActive'])->name('admin.reason_all_active');
Route::get('/admin/reason-all-inactive/{id}', [AdminReasonController::class, 'AdminReasonAllInactive'])->name('admin.reason_all_inactive');

//User Message Routes
Route::get('/admin/user-message-view', [AdminMessageController::class, 'AdminUserMessageView'])->name('admin.user_message_view');
Route::get('/admin/user-message-add', [AdminMessageController::class, 'AdminUserMessageAdd'])->name('admin.user_message_add');
Route::post('/admin/user-message-store', [AdminMessageController::class, 'AdminUserMessageStore'])->name('admin.user_message_store');
Route::get('/admin/user-message-edit/{id}', [AdminMessageController::class, 'AdminUserMessageEdit'])->name('admin.user_message_edit');
Route::post('/admin/user-message-update/{id}', [AdminMessageController::class, 'AdminUserMessageUpdate'])->name('admin.user_message_update');
Route::get('/admin/user-message-delete/{id}', [AdminMessageController::class, 'AdminUserMessageDelete'])->name('admin.user_message_delete');


//User Notice Routes
Route::get('/admin/news-notice-view', [AdminNewsNoticeController::class, 'AdminNewsNoticeView'])->name('admin.news_notice_view');
Route::get('/admin/news-notice-add', [AdminNewsNoticeController::class, 'AdminNewsNoticeAdd'])->name('admin.news_notice_add');
Route::post('/admin/news-notice-store', [AdminNewsNoticeController::class, 'AdminNewsNoticeStore'])->name('admin.news_notice_store');
Route::get('/admin/news-notice-edit/{id}', [AdminNewsNoticeController::class, 'AdminNewsNoticeEdit'])->name('admin.news_notice_edit');
Route::post('/admin/news-notice-image-update', [AdminNewsNoticeController::class, 'AdminNewsNoticeImageUpdate'])->name('admin.news_notice_image_update');
Route::get('/admin/news-notice-image-delete/{id}', [AdminNewsNoticeController::class, 'AdminNewsNoticeImageDelete'])->name('admin.news_notice_image_delete');
Route::post('/admin/news-notice-update/{id}', [AdminNewsNoticeController::class, 'AdminNewsNoticeUpdate'])->name('admin.news_notice_update');
Route::get('/admin/news-notice-delete/{id}', [AdminNewsNoticeController::class, 'AdminNewsNoticeDelete'])->name('admin.news_notice_delete');


//Event Routes
Route::get('/admin/event-view', [AdminEventsController::class, 'AdminEventView'])->name('admin.event_view');
Route::get('/admin/event-add', [AdminEventsController::class, 'AdminEventAdd'])->name('admin.event_add');
Route::post('/admin/event-store', [AdminEventsController::class, 'AdminEventStore'])->name('admin.event_store');
Route::get('/admin/event-edit/{id}', [AdminEventsController::class, 'AdminEventEdit'])->name('admin.event_edit');
Route::post('/admin/event-image-update', [AdminEventsController::class, 'AdminEventImageUpdate'])->name('admin.event_image_update');
Route::get('/admin/event-image-delete/{id}', [AdminEventsController::class, 'AdminEventImageDelete'])->name('admin.event_image_delete');
Route::post('/admin/event-update/{id}', [AdminEventsController::class, 'AdminEventUpdate'])->name('admin.event_update');
Route::get('/admin/event-delete/{id}', [AdminEventsController::class, 'AdminEventDelete'])->name('admin.event_delete');



//Gallery Controller
Route::get('/admin/gallery-view', [AdminGalleryController::class, 'AdminGalleryView'])->name('admin.gallery_view');
Route::get('/admin/gallery-add', [AdminGalleryController::class, 'AdminGalleryAdd'])->name('admin.gallery_add');
Route::post('/admin/gallery-store', [AdminGalleryController::class, 'AdminGalleryStore'])->name('admin.gallery_store');
Route::get('/admin/gallery-edit/{id}', [AdminGalleryController::class, 'AdminGalleryEdit'])->name('admin.gallery_edit');
Route::get('/admin/gallery-details/{id}', [AdminGalleryController::class, 'AdminGalleryDetails'])->name('admin.gallery_details');
Route::post('/admin/gallery-image-update', [AdminGalleryController::class, 'AdminGalleryImageUpdate'])->name('admin.gallery_image_update');
Route::get('/admin/gallery-image-delete/{id}', [AdminGalleryController::class, 'AdminGalleryImageDelete'])->name('admin.gallery_image_delete');
Route::post('/admin/gallery-update/{id}', [AdminGalleryController::class, 'AdminGalleryUpdate'])->name('admin.gallery_update');
Route::get('/admin/gallery-delete/{id}', [AdminGalleryController::class, 'AdminGalleryDelete'])->name('admin.gallery_delete');


Route::get('/admin/videos-view',[AdminVideoController::class, 'AdminVideoView'])->name('admin.video_view');
Route::post('/admin/videos-store',[AdminVideoController::class, 'AdminVideoStore'])->name('admin.video_store');
Route::post('/admin/videos-update/{id}',[AdminVideoController::class, 'AdminVideoEdit'])->name('admin.video_edit');
Route::get('/admin/videos-delete/{id}',[AdminVideoController::class, 'AdminVideoDelete'])->name('admin.video_delete');




//Department Wise Notice
Route::get('/admin/admission-view',[AdminAdmissionController::class, 'AdminAdmissionView'])->name('admin.admission_view');
Route::get('/admin/department-add',[AdminAdmissionController::class, 'AdminAdmissionAdd'])->name('admin.admission_add');
Route::post('/admin/department-store',[AdminAdmissionController::class, 'AdminAdmissionStore'])->name('admin.admission_store');
Route::get('/admin/department-edit/{id}', [AdminAdmissionController::class, 'AdminAdmissionEdit'])->name('admin.admission_edit');
Route::post('/admin/department-update/{id}', [AdminAdmissionController::class, 'AdminAdmissionUpdate'])->name('admin.admission_update');
Route::get('/admin/department-delete/{id}', [AdminAdmissionController::class, 'AdminAdmissionDelete'])->name('admin.admission_delete');
Route::get('/admin/department-active/{id}', [AdminAdmissionController::class, 'AdminAdmissionActive'])->name('admin.admission_active');
Route::get('/admin/department-inactive/{id}', [AdminAdmissionController::class, 'AdminAdmissionInactive'])->name('admin.admission_inactive');




//Department Wise Notice
Route::get('/admin/staff-view',[AdminFacultiesStaffController::class, 'AdminFacultiesStaffUpdate'])->name('admin.facultiesstaff_view');
Route::post('/admin/staff-update',[AdminFacultiesStaffController::class, 'AdminFacultiesStaffStore'])->name('admin.facultiesstaff_store');


Route::get('/admin/academics-view',[AdminAcademicsController::class, 'AdminAcademicsView'])->name('admin.Academics_view');
Route::post('/admin/academics-update',[AdminAcademicsController::class, 'AdminAcademicsStore'])->name('admin.academics_store');


Route::get('/admin/static-videos',[AdminStaticVideoController::class, 'AdminStaticVideo'])->name('admin.static_video');
Route::post('/admin/static-video-store',[AdminStaticVideoController::class, 'AdminStaticVideoStore'])->name('admin.static_video_store');


//Footer Quick Access Links
Route::get('/admin/footer-quick-access',[AdminFooterController::class, 'QuickAccessView'])->name('admin.footer_quick_access');
Route::post('/admin/footer-quick-access-store',[AdminFooterController::class, 'QuickAccessStore'])->name('admin.footer_quick_access_store');
Route::post('/admin/footer-quick-access-update/{id}',[AdminFooterController::class, 'QuickAccessUpdate'])->name('admin.footer_quick_access_update');
Route::get('/admin/footer-quick-access-delete/{id}',[AdminFooterController::class, 'QuickAccessDelete'])->name('admin.footer_quick_access_delete');

//Footer Resources Access Links
Route::get('/admin/footer-resource-view',[AdminResourcesController::class, 'ResourceView'])->name('admin.footer_resource_view');
Route::post('/admin/footer-resource-store',[AdminResourcesController::class, 'ResourceStore'])->name('admin.footer_resource_store');
Route::post('/admin/footer-resource-update/{id}',[AdminResourcesController::class, 'ResourceUpdate'])->name('admin.footer_resource_update');
Route::get('/admin/footer-resource-delete/{id}',[AdminResourcesController::class, 'ResourceDelete'])->name('admin.footer_resource_delete');




//Department Wise Notice
Route::get('/admin/entrance-view',[AdminEntranceController::class, 'AdminEntranceView'])->name('admin.entrance_view');
Route::get('/admin/entrance-add',[AdminEntranceController::class, 'AdminEntranceAdd'])->name('admin.entrance_add');
Route::post('/admin/entrance-store',[AdminEntranceController::class, 'AdminEntranceStore'])->name('admin.entrance_store');
Route::get('/admin/entrance-edit/{id}', [AdminEntranceController::class, 'AdminEntranceEdit'])->name('admin.entrance_edit');
Route::post('/admin/entrance-update/{id}', [AdminEntranceController::class, 'AdminEntranceUpdate'])->name('admin.entrance_update');
Route::get('/admin/entrance-delete/{id}', [AdminEntranceController::class, 'AdminEntranceDelete'])->name('admin.entrance_delete');
Route::get('/admin/entrance-active/{id}', [AdminEntranceController::class, 'AdminEntranceActive'])->name('admin.entrance_active');
Route::get('/admin/entrance-inactive/{id}', [AdminEntranceController::class, 'AdminEntranceInactive'])->name('admin.entrance_inactive');


//Department Wise Notice
Route::get('/admin/entrance-process-view',[AdminEntranceProcessController::class, 'AdminEntranceProcessView'])->name('admin.entrance_process_view');
Route::get('/admin/entrance-process-add',[AdminEntranceProcessController::class, 'AdminEntranceProcessAdd'])->name('admin.entrance_process_add');
Route::post('/admin/entrance-process-store',[AdminEntranceProcessController::class, 'AdminEntranceProcessStore'])->name('admin.entrance_process_store');
Route::get('/admin/entrance-process-edit/{id}', [AdminEntranceProcessController::class, 'AdminEntranceProcessEdit'])->name('admin.entrance_process_edit');
Route::post('/admin/entrance-process-update/{id}', [AdminEntranceProcessController::class, 'AdminEntranceProcessUpdate'])->name('admin.entrance_process_update');
Route::get('/admin/entrance-process-delete/{id}', [AdminEntranceProcessController::class, 'AdminEntranceProcessDelete'])->name('admin.entrance_process_delete');


//Department Wise Notice
Route::get('/admin/entrance-pdf-view',[AdminEntrancepdfController::class, 'AdminEntrancePdfView'])->name('admin.entrance_pdf_view');
Route::get('/admin/entrance-pdf-add',[AdminEntrancepdfController::class, 'AdminEntrancePdfAdd'])->name('admin.entrance_pdf_add');
Route::post('/admin/entrance-pdf-store',[AdminEntrancepdfController::class, 'AdminEntrancePdfStore'])->name('admin.entrance_pdf_store');
Route::get('/admin/entrance-pdf-edit/{id}', [AdminEntrancepdfController::class, 'AdminEntrancePdfEdit'])->name('admin.entrance_pdf_edit');
Route::post('/admin/entrance-pdf-update/{id}', [AdminEntrancepdfController::class, 'AdminEntrancePdfUpdate'])->name('admin.entrance_pdf_update');
Route::get('/admin/entrance-pdf-delete/{id}', [AdminEntrancepdfController::class, 'AdminEntrancePdfDelete'])->name('admin.entrance_pdf_delete');






//Admin Premission Route
Route::get('/admin/dpt-result-premission', [AdminPremissionController::class, 'PremissionDPTResultView'])->name('admin.premission_dpt_result');
Route::get('/admin/department-download-reject/{id}', [AdminPremissionController::class, 'PremissionDPTResultReject'])->name('admin.department_download_reject');
Route::get('/admin/department-download-accept/{id}', [AdminPremissionController::class, 'PremissionDPTResultAccept'])->name('admin.department_download_accept');

//Admin Premission Dwonload
Route::get('/admin/download-premission', [AdminPremissionController::class, 'PremissionDownloadView'])->name('admin.premission_download');
Route::get('/admin/download-reject/{id}', [AdminPremissionController::class, 'PremissionDownloadReject'])->name('admin.download_reject');
Route::get('/admin/download-accept/{id}', [AdminPremissionController::class, 'PremissionDownloadAccept'])->name('admin.download_accept');



//Admin Premission Notice
Route::get('/admin/notice-premission', [AdminPremissionController::class, 'PremissionNoticeView'])->name('admin.premission_notice');
Route::get('/admin/notice-reject/{id}', [AdminPremissionController::class, 'PremissionNoticeReject'])->name('admin.notice_reject');
Route::get('/admin/notice-accept/{id}', [AdminPremissionController::class, 'PremissionNoticeAccept'])->name('admin.notice_accept');


//Admin Premission Gallery
Route::get('/admin/gallery-premission', [AdminPremissionController::class, 'PremissionGalleryView'])->name('admin.premission_gallery');
Route::get('/admin/gallery-reject/{id}', [AdminPremissionController::class, 'PremissionGalleryReject'])->name('admin.gallery_reject');
Route::get('/admin/gallery-accept/{id}', [AdminPremissionController::class, 'PremissionGalleryAccept'])->name('admin.gallery_accept');

