@extends('user.user_master')
@section('user.user_content')
@php
$videos = \App\Models\Video::latest()->paginate(6);
$images = \App\Models\Theme::find(1);
@endphp
<section class="mb-5">
    <!-- Page Content -->
    <div class="page-heading header-text" style="background-image: url('{{asset($images->image)}}');">
        <div class="container page-opacity">
            <div class="row">
                <div class="col-md-12">
                    <h1>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Videos', 'ne') }} @else Videos @endif</h1>
                    <span>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Real knowledge is to know the extent of one’s ignorance.', 'ne') }} @else Real knowledge is to know the extent of one’s ignorance. @endif</span>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Projects Start -->
<section>
    <div class="container-xxl mb-5 mt-5">
        <div class="container">
     
            <div class="row portfolio-container">
                @foreach($videos as $video)

                <div class="col-lg-4 col-md-4 mt-3 portfolio-item">
                <iframe height="250px" width="100%" src="{!! $video->link !!}" title="" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"></iframe>
                </div>
                @endforeach
                
                
                





            </div>
            <div class="col-lg-12 col-md-12 col-sm-12">
                <nav aria-label="Page navigation example" class="mt-5 mb-5">
                    <ul class="pagination justify-content-center" style="font-family: 'Titillium Web', sans-serif;">
                        <div style="box-shadow: 0px 4px 4px 4px rgb(231, 230, 230);display: flex;">
                            {{$videos->links()}}
                        </div>

                    </ul>
                </nav>
            </div>
        </div>
    </div>
</section>
<!-- Projects End -->


@endsection