@extends('admin.admin_master')
@section('admin.admin_content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> Create Message Page</h4>

        <div class="row">
            <div class="col-md-12">

                <div class="card mb-4">
                    <div class="row">
                        <div class="col-6 col">
                            <h5 class="card-header">Add Message Page</h5>

                        </div>
                        <div class="col-6 col card-header">
                            <a href="{{ route('admin.user_message_view') }}"
                                class="float-end btn btn-primary text-nowrap add-new-role">View All Message</a>
                        </div>
                    </div>
                    <!-- Account -->
                    <hr class="my-0" />
                    <div class="card-body">
                        <form id="formAccountSettings" method="POST" action="{{ route('admin.user_message_store') }}"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <h5 class="fw-bold py-3 mb-3">User Message Information</h5>
                                <div class="mb-3 col-md-12">
                                    <label for="slider_heading" class="form-label">User Name <span
                                            class="text-danger">*</span></label>
                                    <select name="user_id" id="user_id" class="form-control">
                                        <option value="">Select User</option>
                                        @foreach ($users as $user)
                                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('user_id')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                </div>
                                <div class="mb-3 col-md-12">
                                    <label for="message_heading" class="form-label">Message Heading <span
                                            class="text-danger">*</span></label>
                                           <input type="text" name="message_heading" class="form-control title_count" placeholder="Principal Message">
                                    @error('message_heading')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                    <span class="characterCount" style="font-size: 12px;"></span> <span style="font-size: 12px;">Enter Only 100 Characters </span>

                                </div>
                                <div class="mb-3 col-md-12">
                                    <label for="message" class="form-label">Message <span
                                            class="text-danger">*</span></label>
                                            <textarea name="message" id="message" class="form-control ckeditor" cols="5" rows="5"></textarea>
                                   
                                    @error('message')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div> 
                           
                            <div class="mt-2 float-end">
                                <button type="submit" class="btn btn-primary me-2">Add Message</button>
                                <button type="reset" class="btn btn-outline-secondary">Cancel</button>
                            </div>
                    </div>

                    </form>
                </div>
                <!-- /Account -->
            </div>
        </div>
    </div>
    </div>
    <!-- / Content -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
        function mainProImgUrl(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#adminProImg').attr('src', e.target.result).width(80).height(80);
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
     <script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
     <script type="text/javascript">
         $(document).ready(function() {
             $('.ckeditor').ckeditor();
         });
     </script>
 
@endsection
