@extends('admin.admin_master')
@section('admin.admin_content')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/css/jquery.dataTables.min.css"
        integrity="sha512-1k7mWiTNoyx2XtmI96o+hdjP8nn0f3Z2N4oF/9ZZRgijyV4omsKOXEnqL1gKQNPy2MTSP9rIEWGcH/CInulptA=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- ✅ load jQuery ✅ -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js"
        integrity="sha512-aVKKRRi/Q/YV+4mjoKBsE4x3H+BkegoM/em46NNlCqNTmUYADjBbeNefNxYV7giUp0VxICtqdrbqU7iVaeZNXA=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>


    <!-- ✅ load DataTables ✅ -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/js/jquery.dataTables.min.js"
        integrity="sha512-BkpSL20WETFylMrcirBahHfSnY++H2O1W+UnEEO4yNIl+jI2+zowyoGJpbtk6bx97fBXf++WJHSSK2MV4ghPcg=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <!-- Content -->
    <section>

        <div class="container-xxl flex-grow-1 container-p-y">
            <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> View Users</h4>

            @php
                $i = 1;
            @endphp
            <!-- Basic Bootstrap Table -->
            <div class="card">
                <div class="row">
                    <div class="col-6 col">
                        <h5 class="card-header">List Users</h5>

                    </div>
                    <div class="col-6 col card-header">
                        <a href="{{route('admin.user_add_view')}}"
                            class="float-end btn btn-primary text-nowrap add-new-role text-white">Add New User</a>
                    </div>
                </div>


                <div class="table-responsive text-nowrap pe-3 ps-3 pb-3">
                    <table class="table" id="exampleTable" width="100%">
                        <thead>
                            <tr class="text-nowrap">
                                <th>SN</th>
                                <th>Image</th>
                                <th>User Name</th>
                                <th>Email</th>
                                <th>User Type</th>
                                <th>Phone Number</th>
                                <th>Address</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                            @foreach ($users as $user)
                                <tr>
                                    <td>{{ $i++ }}</td>
                                    <td><img src="{{(!empty($user->profile_photo_path))?url($user->profile_photo_path):url('./uploads/default_images/no_image.jpg')}}" width="40px" style="border-radius: 50%" alt=""></td>
                                    <td>{{ $user->name }}</td>
                                    <td>{{ $user->email }}</td>
                                    <td>{{ $user->admin_type }}</td>
                                    <td> 
                                    @if($user->phone > 1)
                                    {{ $user->phone }}
                                    @else
                                    <span class="badge bg-danger">Empty</span>
                                    @endif

                                    </td>
                                    <td>@if($user->address > 1)
                                        {{ $user->address }}
                                        @else
                                        <span class="badge bg-danger">Empty</span>
                                        @endif</td>
                                        <td><a href="{{ route('admin.user_all_edit',$user->id) }}" class="btn btn-primary">Edit</a>
                                        <a href="{{ route('admin.user_all_delete',$user->id) }}" class="btn btn-danger" id="deleteData">Delete</a>
                                    </td>
                                </tr>
                                
                              
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <!--/ Basic Bootstrap Table -->
        </div>
        <!-- / Content -->

    </section>
    <script>
        $(document).ready(function() {
            $.noConflict();
            $('#exampleTable').DataTable();
        });
    </script>
@endsection
