@extends('admin.admin_master')
@section('admin.admin_content')
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> Create New Account</h4>

    <div class="row">
        <div class="col-md-12">

            <div class="card mb-4">
                <div class="row">
                    <div class="col-6 col">
                        <h5 class="card-header">Add New Admin</h5>

                    </div>
                    <div class="col-6 col card-header">
                        <a href="{{route('admin.user_all_view')}}" class="float-end btn btn-primary text-nowrap add-new-role">View All Admin</a>
                    </div>
                </div>
                <!-- Account -->
                <hr class="my-0" />
                <div class="card-body">
                    <form id="formAccountSettings" method="POST" action="{{ route('admin.user_add_info_store') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <h5 class="fw-bold py-3 mb-3">Account Information</h5>
                            <div class="mb-3 col-md-6">
                                <label for="firstName" class="form-label">Full Name <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" id="name" name="name" placeholder="Jhon Doe" />
                                @error('name')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="mb-3 col-md-6">
                                <label for="email" class="form-label">E-mail <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" id="email" name="email" placeholder="example@example.com" />
                                @error('email')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="mb-3 col-md-6">
                                <label for="admin_type" class="form-label">Admin Type <span class="text-danger">*</span></label>
                                <select id="admin_type" name="admin_type" class="select2 form-select">
                                    <option value="">Select Admin Type</option>
                                    <option value="Author User">Author Admin</option>
                                    <option value="Editor User">Editor Admin</option>
                                    <option value="Normal User">Normal User</option>
                                </select>
                                @error('admin_type')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="mb-3 col-md-6">
                                <label for="email" class="form-label">User Post <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" id="user_post" name="user_post" placeholder="Ma.Vi. Center Principal" />
                                @error('user_post')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>

                            <h5 class="fw-bold py-3 mb-3">Contact Information</h5>
                            <div class="mb-3 col-md-6">
                                <label for="organization" class="form-label">Website</label>
                                <input type="text" class="form-control" id="website" name="website" placeholder="www.example.com" />
                                @error('website')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="mb-3 col-md-6">
                                <label class="form-label" for="phone">Phone Number</label>
                                <div class="input-group input-group-merge">
                                    <span class="input-group-text">NP (+977)</span>
                                    <input type="text" id="phone" name="phone" class="form-control" placeholder="9800000000" />
                                </div>
                                @error('phone')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="mb-3 col-md-6">
                                <label for="organization" class="form-label">Facebook Link</label>
                                <input type="text" class="form-control" id="facebook_link" name="facebook_link" placeholder="www.example.com" />
                                @error('facebook_link')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="mb-3 col-md-6">
                                <label for="address" class="form-label">Address</label>
                                <input type="text" class="form-control" id="address" name="address" placeholder="Address" />
                                @error('address')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>


                            <div class="mb-3 col-md-12">
                                <label for="about" class="form-label">Biographical Info</label>
                                <textarea id="basic-default-message" class="form-control" name="about" placeholder="Biographical Info.."></textarea>
                                @error('about')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div id="password_section_hide">
                                <h5 class="fw-bold py-3 mb-3">Application Passwords</h5>
                                <div class="row">
                                    <div class="mb-3 col-md-6">
                                        <label for="password" class="form-label">New Password <span class="text-danger">*</span></label>
                                        <input type="password" class="form-control" id="password" name="password" placeholder="New Password" />
                                        @error('password')
                                        <p class="text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>
                                    <div class="mb-3 col-md-6">
                                        <label for="zipCode" class="form-label">Confirm Password <span class="text-danger">*</span></label>
                                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" placeholder="Confirm Password" />
                                        @error('confirm_password')
                                        <p class="text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <h5 class="fw-bold py-3 mb-3">Profile Image</h5>
                            <div class="mb-3 col-md-6">
                                <label for="profile_photo_path" class="form-label">Image</label>
                                <input type="file" class="form-control" id="profile_photo_path" name="profile_photo_path" onchange="mainProImgUrl(this)" accept="image/png, image/jpeg" />
                                @error('profile_photo_path')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="mb-3 col-md-6">
                                <img src="{{ asset('./uploads/default_images/no_image.jpg') }}" alt="" id="adminProImg" width="80px" height="80px">
                            </div>
                        </div>
                        <div class="mt-2 float-end">
                            <button type="submit" class="btn btn-primary me-2">Add User</button>
                            <button type="reset" class="btn btn-outline-secondary">Cancel</button>
                        </div>
                    </form>
                </div>
                <!-- /Account -->
            </div>
        </div>
    </div>
</div>
<!-- / Content -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
    function mainProImgUrl(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#adminProImg').attr('src', e.target.result).width(80).height(80);
            };
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>

<script type="text/javascript">
    $(function() {
        $(document).on('change', '#admin_type', function() {
            var user_type = $('#admin_type').val();
            if (user_type == "Normal User") {
                const element = document.getElementById('password_section_hide');
                element.style.display = "none";
            } else {
                const element = document.getElementById('password_section_hide');
                element.style.display = "block";
            }
        });
    });
</script>
@endsection