@extends('admin.admin_master')
@section('admin.admin_content')
    <!-- Content -->
    @php
        use Illuminate\Support\Facades\Auth;
        
        $admin_info = Auth::user();
    @endphp
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Account Settings /</span> Account</h4>

        <div class="row">
            <div class="col-md-12">

                <div class="card mb-4">
                    <h5 class="card-header">Profile Details</h5>
                    <!-- Account -->
                    <form action="{{ route('admin.profile_image') }}" method="post" enctype="multipart/form-data">

                        @csrf <div class="card-body">
                            <div class="d-flex align-items-start align-items-sm-center gap-4">
                                <img src="{{ !empty($admin_info->profile_photo_path) ? url($admin_info->profile_photo_path) : url('./uploads/default_images/no_image.jpg') }}"
                                    alt="user-avatar" id="adminProImg" class="d-block rounded" height="100" width="100"
                                    id="uploadedAvatar" />
                                <div class="button-wrapper">
                                    <label for="upload" class="btn btn-primary me-2 mb-4" tabindex="0">
                                        <span class="d-none d-sm-block">Upload new photo</span>
                                        <i class="bx bx-upload d-block d-sm-none"></i>
                                        <input type="file" id="upload" name="profile_photo_path"
                                            class="account-file-input" hidden onchange="mainProImgUrl(this)" accept="image/png, image/jpeg" />
                                    </label>
                                    @error('profile_photo_path')
                                    <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                    <button type="submit" class="btn btn-outline-secondary account-image-reset mb-4">
                                        <i class="bx bx-reset d-block d-sm-none"></i>
                                        <span class="d-none d-sm-block">Update</span>
                                    </button>

                                    <p class="text-muted mb-0">Allowed JPG, GIF or PNG. Max size of 800K</p>
                                </div>
                            </div>
                        </div>
                    </form>
                    <hr class="my-0" />
                    <div class="card-body">
                        <form id="formAccountSettings" action="{{ route('admin.profile_info_store') }}" method="POST" >
                            @csrf
                            <div class="row">
                                <div class="mb-3 col-md-6">
                                    <label for="name" class="form-label">Name</label>
                                    <input class="form-control" type="text" id="name" name="name"
                                        value="{{ $admin_user->name }}" autofocus />
                                       @error('name')
                                       <p class="text-danger">{{ $message }}</p>
                                       @enderror
                                </div>
                                <div class="mb-3 col-md-6">
                                    <label for="lastName" class="form-label">E-mail</label>
                                    <input class="form-control" type="email" name="email" id="email"
                                        value="{{ $admin_user->email }}" disabled />
                                        @error('email')
                                    <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-6">
                                    <label class="form-label" for="phone">Phone Number</label>
                                    <div class="input-group input-group-merge">
                                        <span class="input-group-text">NP (+977)</span>
                                        <input type="text" id="phone" name="phone" class="form-control"
                                            placeholder="-977 9800000000" value="{{ $admin_user->phone }}" />
                                            @error('phone')
                                            <p class="text-danger">{{ $message }}</p>
                                            @enderror
                                    </div>
                                </div>
                                <div class="mb-3 col-md-6">
                                    <label for="address" class="form-label">Address</label>
                                    <input type="text" class="form-control" id="address" name="address"
                                        placeholder="Address" value="{{ $admin_user->address }}" />
                                        @error('address')
                                        <p class="text-danger">{{ $message }}</p>
                                        @enderror
                                </div>
                                <div class="mb-3 col-md-6">
                                    <label for="dob" class="form-label">Date Of Birth</label>
                                    <input class="form-control" type="date" id="dob" name="dob"
                                        placeholder="01/03/2023" value="{{ $admin_user->dob }}" />
                                        @error('dob')
                                        <p class="text-danger">{{ $message }}</p>
                                        @enderror
                                </div>

                                <div class="mb-3 col-md-6">
                                    <label for="website" class="form-label">Website</label>
                                    <input class="form-control" type="text" id="website" name="website"
                                        placeholder="www.example.com" value="{{ $admin_user->website }}" />
                                        @error('website')
                                        <p class="text-danger">{{ $message }}</p>
                                        @enderror
                                </div>
                                <div class="mb-3 col-md-12">
                                    <label for="facebook_link" class="form-label">Facebook Link</label>
                                    <input class="form-control" type="text" id="facebook_link" name="facebook_link"
                                        placeholder="https://www.facebook.com/"
                                        value="{{ $admin_user->facebook_link }}" />
                                        @error('facebook_link')
                                        <p class="text-danger">{{ $message }}</p>
                                        @enderror
                                </div>
                                <div class="mb-3 col-md-12">
                                    <label for="facebook_link" class="form-label">About</label>
                                    <textarea name="about" class="form-control" id="" cols="30" rows="10">{{ $admin_user->about }}</textarea>
                                </div>
                            </div>
                            <div class="mt-2">
                                <button type="submit" class="btn btn-primary me-2">Update Profile</button>
                                <button type="reset" class="btn btn-outline-secondary">Cancel</button>
                            </div>
                        </form>
                    </div>
                    <!-- /Account -->
                </div>
                <div class="card">
                    <h5 class="card-header">Delete Account</h5>
                    <div class="card-body">
                        <div class="mb-3 col-12 mb-0">
                            <div class="alert alert-warning">
                                <h6 class="alert-heading fw-bold mb-1">Are you sure you want to delete your account?</h6>
                                <p class="mb-0">Once you delete your account, there is no going back. Please be certain.
                                </p>
                            </div>
                        </div>
                        <form id="formAccountDeactivation" onsubmit="return false">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" name="accountActivation"
                                    id="accountActivation" />
                                <label class="form-check-label" for="accountActivation">I confirm my account
                                    deactivation</label>
                            </div>
                            <button type="submit" class="btn btn-danger deactivate-account">Deactivate Account</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- / Content -->
    
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
    function mainProImgUrl(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#adminProImg').attr('src', e.target.result).width(80).height(80);
            };
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
@endsection
