@extends('admin.admin_master')
@section('admin.admin_content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/css/jquery.dataTables.min.css" integrity="sha512-1k7mWiTNoyx2XtmI96o+hdjP8nn0f3Z2N4oF/9ZZRgijyV4omsKOXEnqL1gKQNPy2MTSP9rIEWGcH/CInulptA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<!-- ✅ load jQuery ✅ -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js" integrity="sha512-aVKKRRi/Q/YV+4mjoKBsE4x3H+BkegoM/em46NNlCqNTmUYADjBbeNefNxYV7giUp0VxICtqdrbqU7iVaeZNXA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>


<!-- ✅ load DataTables ✅ -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/js/jquery.dataTables.min.js" integrity="sha512-BkpSL20WETFylMrcirBahHfSnY++H2O1W+UnEEO4yNIl+jI2+zowyoGJpbtk6bx97fBXf++WJHSSK2MV4ghPcg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<!-- Content -->

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> View Gallery</h4>

    @php
    $i = 1;
    @endphp
    <!-- Basic Bootstrap Table -->
    <div class="card">
        <div class="row">
            <div class="col-6 col">
                <h5 class="card-header">List Gallery</h5>

            </div>
            <div class="col-6 col card-header">
                <a href="{{ route('admin.gallery_add') }}" class="float-end btn btn-primary text-nowrap add-new-role text-white">Add New Gallery</a>
            </div>
        </div>


        <div class="table-responsive text-nowrap pe-3 ps-3 pb-3">
            <table class="table" id="exampleTable" width="100%">
                <thead>
                    <tr class="text-nowrap">
                        <th>SN</th>
                        <th>Gallery Title</th>
                        <th>Details</th>
                        <th>Pending</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody class="table-border-bottom-0">
                    @foreach ($gallery as $item)
                    <tr>
                        <td>{{ $i++ }}</td>
                        <td>{{$item->title}}</td>
                        <td><a class="btn btn-primary" href="{{route('admin.gallery_details',$item->id)}}">Details</a></td>
                        @php
                        $user_auth = \Illuminate\Support\Facades\Auth::user();
                        @endphp
                        @if($user_auth->admin_type == "Author User")
                        <td>
                            <a class="btn btn-danger" href="{{route('admin.gallery_delete',$item->id)}}" id="deleteData"><i class="bi bi-trash"></i></a>
                            <a href="{{ route('admin.gallery_reject', $item->id) }}" class="btn btn-sm btn-danger" title="Reject"><i class="bi bi-x-lg"></i></a>
                            <a href="{{ route('admin.gallery_accept', $item->id) }}" class="btn btn-sm btn-primary" title="Posted"><i class="bi bi-check-lg"></i></a>
                        </td>


                        @endif
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <!--/ Basic Bootstrap Table -->
</div>
<!-- / Content -->

<script>
    $(document).ready(function() {
        $.noConflict();
        $('#exampleTable').DataTable();
    });
</script>
@endsection