@extends('admin.admin_master')
@section('admin.admin_content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/css/jquery.dataTables.min.css" integrity="sha512-1k7mWiTNoyx2XtmI96o+hdjP8nn0f3Z2N4oF/9ZZRgijyV4omsKOXEnqL1gKQNPy2MTSP9rIEWGcH/CInulptA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<!-- ✅ load jQuery ✅ -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js" integrity="sha512-aVKKRRi/Q/YV+4mjoKBsE4x3H+BkegoM/em46NNlCqNTmUYADjBbeNefNxYV7giUp0VxICtqdrbqU7iVaeZNXA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<!-- ✅ load DataTables ✅ -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/js/jquery.dataTables.min.js" integrity="sha512-BkpSL20WETFylMrcirBahHfSnY++H2O1W+UnEEO4yNIl+jI2+zowyoGJpbtk6bx97fBXf++WJHSSK2MV4ghPcg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<!-- Content -->
<section>
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> View Events</h4>

        @php
        $i = 1;
        @endphp
        <!-- Basic Bootstrap Table -->
        <div class="card">
            <div class="row">
                <div class="col-6 col">
                    <h5 class="card-header">List Events</h5>

                </div>
                <div class="col-6 col card-header">
                    <a href="{{ route('admin.event_add') }}" class="float-end btn btn-primary text-nowrap add-new-role text-white">Add New Events</a>
                </div>
            </div>
            <div class="table-responsive text-nowrap pe-3 ps-3 pb-3">
                <table class="table" id="exampleTable" width="100%">
                    <thead>
                        <tr class="text-nowrap">
                            <th>SN</th>
                            <th>Events Name</th>
                            <th>Events Image</th>
                            <th>Events Time</th>
                            <th>Published By</th>
                            <th>Published Date</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        @foreach($event_view as $key=>$event)

                        @php
                        $images = \App\Models\EventImage::where('event_id',$event->id)->get();
                        @endphp
                        <tr>
                            <td>
                                {{$key+1}}
                            </td>
                            <td>{{$event->event_title}}</td>

                            <td>
                                @foreach($images as $image)
                                <img src="{{asset($image->image)}}" width="40px" alt="">
                                @endforeach
                            </td>
                            <td>{{$event->user->name}}</td>
                            <td>@php
                                $year = $event->created_at->format('Y');
                                $month = $event->created_at->format('m');
                                $day = $event->created_at->format('d');
                                $date = Bsdate::eng_to_nep($year, $month, $day);
                                echo $date['date'] . ' ' . $date['nmonth'] . ' ' . $date['year'] . ',' . $date['day'];
                                @endphp</td>
                            <td>
                            @php
                                $user_auth = \Illuminate\Support\Facades\Auth::user();
                                @endphp
                                @if($user_auth->admin_type == "Author User")
                                <a href="{{route('admin.event_edit',$event->id)}}" class="btn btn-primary">Edit</a> <a href="{{route('admin.event_delete',$event->id)}}" class="btn btn-danger" id="deleteData">Delete</a>
                                @else
                                <span class="text-danger">Action connot access</span>
                                @endif
                            </td>

                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <!--/ Basic Bootstrap Table -->
    </div>
    <!-- / Content -->

</section>
<script>
    $(document).ready(function() {
        $.noConflict();
        $('#exampleTable').DataTable();
    });
</script>
@endsection