<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\DepartmentDownload;
use Illuminate\Http\Request;
use App\Models\DepartmentDownloadFile;
use App\Models\Download;
use Illuminate\Support\Facades\Storage;
use File;
use ZipArchive;

class UserResultController extends Controller
{
    //Result View
    public function UserResultView($id, $slug)
    {
        $result = \App\Models\DepartmentDownload::where('course_id', $id)->where('status',1)->where('public',1)->get();
        $result_name = \App\Models\DepartmentDownload::where('course_id', $id)->where('status',1)->where('public',1)->first();
        if ($result_name == "") {
            return abort(404);
        } else {
            return view('user.results.result', compact('result', 'result_name'));
        }
    }

    //Result Details View
    public function UserResultsDownload($id)
    {
        $result_details = \App\Models\DepartmentDownloadFile::find($id);
        $pdf_path = $result_details->file;
        return Storage::download($pdf_path);
    }

    //Result Download All
    public function UserResultsDownloadView($id)
    {

        $down = DepartmentDownload::find($id);
        $downloads = \App\Models\DepartmentDownloadFile::where('download_id', $id)->get();
        return view('user.results.result_details', compact('downloads', 'down'));
    }

    //Result Details View
    public function UserResultsView($id)
    {
        $result_details = \App\Models\DepartmentDownloadFile::find($id);
        $pdf_path = Storage::disk('local')->path($result_details->file);
        return response()->file($pdf_path);
    }
}
