<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventImage;
use Illuminate\Http\Request;

class UserEventController extends Controller
{
    //User Event List View
    public function EventManageView()
    {
        $events = Event::latest()->paginate(12);
        return view('user.event.event_view',compact('events'));
    }

    //User Event Details View
    public function EventManageDetailsView($id, $slug){
        $events_details = Event::find($id);
        $related_notice = EventImage::where('id','!=',$id)->get();
        return view('user.event.event_details',compact('events_details','related_notice'));
    }
}
