<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Validator;
use Mail;
class UserContactController extends Controller
{
    //User Contact View
    public function ContactView()
    {
        return view('user.contact.contact');
    }

    public function sendEmail(Request $request)
    {
       
        $validation = Validator::make($request->all(), [
            'name'=>'required',
          'email' => 'required|email',
          'subject' => 'required',
          'content' => 'required',
        ]);
        if ($validation->fails()) {
            return response()->json(['code' => 400, 'msg' => $validation->errors()->first()]);
        }
        $data = [
          'subject' => $request->subject,
          'name' => $request->name,
          'email' => $request->email,
          'content' => $request->content,
        ];

        Mail::send('email-contact-send', $data, function($message) use ($data) {
          $message->to('sushilkc908@gmail.com')
          ->subject($data['subject']);
        });
        return response()->json(['code' => 200, 'msg' => 'Thanks for contacting us, we will get back to you soon.']);
    }
}
