<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Reason;
use Dotenv\Loader\Resolver;
use Illuminate\Support\Str;
use Intervention\Image\Facades\Image;
use RealRashid\SweetAlert\Facades\Alert;
use App\Models\User;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class AdminReasonController extends Controller
{

    //Reason Page View
    public function AdminReasonAllView()
    {
        Session::put('admin_page', 'admin_static_view');
        $reason_pages = Reason::latest()->get();
        return view('admin.reason.reason_view', compact('reason_pages'));
    }
    //Course Page Add 
    public function AdminReasonAllAdd()
    {
        Session::put('admin_page', 'admin_static_view');
        return view('admin.reason.reason_add');
    }

    //Course Page Edit 
    public function AdminReasonAllEdit($id)
    {
        Session::put('admin_page', 'admin_static_view');
        $reason_edit = Reason::find($id);
        return view('admin.reason.reason_edit', compact('reason_edit'));
    }

    //Course Page Add 
    public function AdminReasonAllStore(Request $request)
    {
        $request->validate([
            'reason_name' => 'max:255|required',
            'short_des' => 'max:500|required',
            'des' => 'required',
            'icon' => 'required',
        ]);
        $reason_add = new Reason();
        $reason_add->reason_name = $request->reason_name;
        $reason_add->short_des = $request->short_des;
        $reason_add->reason_name_slug     = Str::slug($request->reason_name);
        $reason_add->des = $request->des;
        $reason_add->status = 0;
        if ($request->file('icon')) {
            $file = $request->file('icon');
            @unlink($reason_add->icon);
            $filename = date('YmsHi') . $file->getClientOriginalName();
            Image::make($file)->save('./uploads/reason_icon/' . $filename);
            $uploadPath = './uploads/reason_icon/' . $filename;
        }
        $reason_add->icon = $uploadPath;
        $reason_add->save();
        Toastr::success('Reason Page Created Successfully');
        return redirect()->back();
    }

    //Course Page update 
    public function AdminReasonAllUpdate(Request $request, $id)
    {
        $request->validate([
            'reason_name' => 'max:255|required',
            'short_des' => 'max:500|required',
            'des' => 'required',
            'icon' => 'nullable',
        ]);
        $reason_add = Reason::find($id);
        $reason_add->reason_name = $request->reason_name;
        $reason_add->short_des = $request->short_des;
        $reason_add->reason_name_slug= Str::slug($request->reason_name);
        $reason_add->des = $request->des;
        $reason_add->status = 0;
        if ($request->file('icon')) {
            $file = $request->file('icon');
            @unlink($reason_add->icon);
            $filename = date('YmsHi') . $file->getClientOriginalName();
            Image::make($file)->save('./uploads/reason_icon/' . $filename);
            $uploadPath = './uploads/reason_icon/' . $filename;
            $reason_add->icon = $uploadPath;
        }
        $reason_add->save();
        Toastr::success('Reason Page Updated Successfully');
        return redirect()->back();
    }



    public function AdminReasonAllDelete($id)
    {
        $reason_page_delete = Reason::find($id);
        @unlink($reason_page_delete->icon);
        Toastr::success('Reason Page Deleted Successfully');
        $reason_page_delete->delete();
        return redirect()->back();
    }
}
