<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Message;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Intervention\Image\Facades\Image;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Session;
use Brian2694\Toastr\Facades\Toastr;


class AdminMessageController extends Controller
{
    //Admin Message View
    public function AdminUserMessageView()
    {
        Session::put('admin_page', 'admin_about_view');
        $message = Message::latest()->get();
        return view('admin.user_message.user_message_view', compact('message'));
    }

    //Admin Message Add
    public function AdminUserMessageAdd()
    {
        Session::put('admin_page', 'admin_about_view');
        $users = User::latest()->get();
        return view('admin.user_message.user_message_add', compact('users'));
    }

    //Admin Message Store
    public function AdminUserMessageStore(Request $request)
    {
        $request->validate([
            'user_id' => 'max:255|required',
            'message_heading' => 'max:255|required',
            'message' => 'required',
        ]);
        $message_add = new Message();
        $message_add->user_id = $request->user_id;
        $message_add->message_heading = $request->message_heading;
        $message_add->message_heading_slug = Str::slug($request->message_heading);
        $message_add->message = $request->message;
        $message_add->save();
        Toastr::success('Message Page Added Successfully');
        return redirect()->back();
    }
    //Admin Message Edit
    public function AdminUserMessageEdit($id)
    {
        Session::put('admin_page', 'admin_about_view');
        $users = User::latest()->get();
        $message = Message::find($id);
        return view('admin.user_message.user_message_edit', compact('users', 'message'));
    }
    //User Message Update
    public function AdminUserMessageUpdate(Request $request, $id)
    {
        $request->validate([
            'user_id' => 'max:255|required',
            'message_heading' => 'max:255|required',
            'message' => 'required',
        ]);
        $message_add = Message::find($id);
        $message_add->user_id = $request->user_id;
        $message_add->message_heading = $request->message_heading;
        $message_add->message_heading_slug = Str::slug($request->message_heading);
        $message_add->message = $request->message;
        $message_add->save();
        Toastr::success('Message Page Updated Successfully');
        return redirect()->back();
    }

    //Admin Message Delete
    public function AdminUserMessageDelete($id)
    {
        $message_delete = Message::find($id);
        $message_delete->delete();
        Toastr::success('Message Deleted Successfully');
        return redirect()->back();
    }
}
