<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\EntranceProcess;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;
use App\Models\DownloadFile;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use Brian2694\Toastr\Facades\Toastr;

class AdminEntranceProcessController extends Controller
{
    //Admin Entrance Process View 
    public function AdminEntranceProcessView()
    {
        $entrance = EntranceProcess::latest()->get();
        return view('admin.entrance_process.entrance_process_view', compact('entrance'));
    }


    //Admin Entrance Process Add
    public function AdminEntranceProcessAdd()
    {

        return view('admin.entrance_process.entrance_process_add');
    }

    
    //Admin Entrance Process Add
    public function AdminEntranceProcessEdit($id)
    {

        $edit_process = EntranceProcess::find($id);
        return view('admin.entrance_process.entrance_process_edit', compact('edit_process'));
    }


    
    //Admin Entrance Process Store
    public function AdminEntranceProcessStore(Request $request)
    {

        $request->validate([
            'title' => 'max:255|required',
            'para' => 'required',
            'sequence' =>'required|max:255',
        ]);
        $store = new EntranceProcess();
        $store->title = $request->title;
        $store->title_slug = Str::slug($request->title);
        $store->sequence = $request->sequence;
        $store->para = $request->para;
        $store->save();
        Toastr::success('Entrance Process Added Successfully');
        return redirect()->back();
    }


    //Admin Entrance Process Edit
    public function AdminEntranceProcessUpdate(Request $request, $id)
    {
        $request->validate([
            'title' => 'max:255|required',
            'para' => 'required',
            'sequence' =>'required|max:255',
        ]);
        $store = EntranceProcess::find($id);
        $store->title = $request->title;
        $store->title_slug = Str::slug($request->title);
        $store->sequence = $request->sequence;
        $store->para = $request->para;
        $store->save();
        Toastr::success('Entrance Process Updated Successfully');
        return redirect()->back();
    }


    //Admin Entrance Process Delete
    public function AdminEntranceProcessDelete($id)
    {
        $delete = EntranceProcess::find($id);
        $delete->delete();
        Toastr::success('Entrance Process Delete Successfully');
        return redirect()->back();
    }
}
